﻿/*
   Prosty program obsługi portu szeregowego
   Kontekst: Arduino

   Nasłuchuje przychodzących bajtów na porcie szeregowym, 
   dodaje jeden do bajtu i wysyła wynik z powrotem.
   Również miga diodą LED na pinie 13 co pół sekundy.
*/

int LEDPin = 13;            // można użyć dowolnego cyfrowego pinu 
                            // wejścia-wyjścia (I/O) 
int inByte = 0;             // zmienna do przechowywania 
                            // przychodzących danych
long blinkTimer = 0;        // służy do śledzenia, ile czasu upłynęło 
                            // od ostatniego wyłączenia diody LED 
int blinkInterval = 1000;   // pełna sekunda od włączonej do wyłączonej 
                            // i ponownie do włączonej 

void setup() {
  pinMode(LEDPin, OUTPUT);   // ustaw pin 13 jako wyjście 
  Serial.begin(9600);        // ustaw szybkość danych portu 
                             // szeregowego na 9600 b/s.
}

void loop() {
  // jeśli na porcie szeregowym są jakieś 
  // przychodzące bajty do odczytania:
  if (Serial.available() > 0) {
    // odczytaj pierwszy dostępny bajt:
    inByte = Serial.read();
    // dodaj jeden, a następnie odeślij wynik:
    Serial.write(inByte+1);
  }

  // w międzyczasie niech miga dioda LED.
  // po pół sekundy włącz diodę LED:
  if (millis() - blinkTimer >= blinkInterval / 2) {
    digitalWrite(LEDPin, HIGH);     // włącz LED na pinie 13
  }
  // po pół sekundy wyłącz diodę LED i zresetuj licznik czasu:
  if (millis() - blinkTimer >= blinkInterval) {
    digitalWrite(LEDPin, LOW);      // wyłącz LED
    blinkTimer = millis();          // zresetuj licznik czasu
  }
}
