/*
 * Decompiled with CFR 0.152.
 */
package cc.arduino.btserial;

import android.bluetooth.BluetoothSocket;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class ConnectedThread
extends Thread {
    private final BluetoothSocket mmSocket;
    private final int mBufferLength;
    protected final InputStream mmInStream;
    protected final OutputStream mmOutStream;
    private byte[] buffer;
    private int bufferIndex;
    private int bufferLast;
    private int available;

    public ConnectedThread(BluetoothSocket bluetoothSocket, int n) {
        this.mmSocket = bluetoothSocket;
        InputStream inputStream = null;
        OutputStream outputStream = null;
        this.mBufferLength = n;
        try {
            inputStream = bluetoothSocket.getInputStream();
            outputStream = bluetoothSocket.getOutputStream();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.mmInStream = inputStream;
        this.mmOutStream = outputStream;
        this.buffer = new byte[this.mBufferLength];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public void run() {
        try {
            while (true) {
                if (this.mmInStream.available() <= 0) {
                    continue;
                }
                byte[] byArray = this.buffer;
                // MONITORENTER : this.buffer
                if (this.bufferLast == this.buffer.length) {
                    byte[] byArray2 = new byte[this.bufferLast << 1];
                    System.arraycopy(this.buffer, 0, byArray2, 0, this.bufferLast);
                    this.buffer = byArray2;
                }
                this.buffer[this.bufferLast++] = (byte)this.mmInStream.read();
                // MONITOREXIT : byArray
            }
        }
        catch (IOException iOException) {
            return;
        }
    }

    public void write(byte[] byArray) {
        try {
            this.mmOutStream.write(byArray);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] read() {
        if (this.bufferIndex == this.bufferLast) {
            return null;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int n = this.bufferLast - this.bufferIndex;
            byte[] byArray2 = new byte[n];
            System.arraycopy(this.buffer, this.bufferIndex, byArray2, 0, n);
            this.bufferIndex = 0;
            this.bufferLast = 0;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return byArray2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readByte() {
        if (this.bufferIndex == this.bufferLast) {
            return -1;
        }
        byte[] byArray = this.buffer;
        synchronized (this.buffer) {
            int n = this.buffer[this.bufferIndex++] & 0xFF;
            if (this.bufferIndex == this.bufferLast) {
                this.bufferIndex = 0;
                this.bufferLast = 0;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return n;
        }
    }

    public int available() {
        return this.bufferLast - this.bufferIndex;
    }

    public void clear() {
        this.bufferLast = 0;
        this.bufferIndex = 0;
    }

    public void cancel() {
        try {
            this.mmSocket.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }
}

