#!/bin/bash
#nazwa pliku: intruder_detect.sh
#opis: narzędzie raportujące o intruzach przy użyciu pliku wejściowego auth.log
AUTHLOG=/var/log/auth.log

if [[ -n $1 ]];
then
  AUTHLOG=$1
  echo Używany plik dziennika: $AUTHLOG
fi

# Wyodrębnianie danych o próbach logowania zakończonych niepowodzeniem
LOG=/tmp/failed.$$.log
grep "Failed pass" $AUTHLOG > $LOG

# Wyodrębnianie danych o użytkownikach, którym nie udało się zalogować
users=$(cat $LOG | awk '{ print $(NF-5) }' | sort | uniq)

# Wyodrębnianie adresów IP, z których podejmowano nieudane próby logowania
ip_list="$(egrep -o "[0-9]+\.[0-9]+\.[0-9]+\.[0-9]+" $LOG | sort | uniq)"


printf "%-10s|%-3s|%-16s|%-33s|%s\n" "Użytkownik" "Próby" "Adres IP" \ "Odwzorowany host" "Przedział czasu"

# Pętla przetwarzająca adresy IP i użytkowników, których logowanie się nie powiodło.

for ip in $ip_list;
do
  for user in $users;
    do
    # Liczymy próby tego użytkownika, logującego się z tego adresu IP

    attempts=`grep $ip $LOG | grep " $user " | wc -l`

    if [ $attempts -ne 0 ] 
    then
      first_time=`grep $ip $LOG | grep " $user " | head -1 | cut -c-16`
      time="$first_time"
      if [ $attempts -gt 1 ] 
      then
        last_time=`grep $ip $LOG | grep " $user " | tail -1 | cut -c-16`
        time="$first_time -> $last_time"
      fi
      HOST=$(host $ip 8.8.8.8 | tail -1 | awk '{ print $NF }' )
      printf "%-10s|%-3s|%-16s|%-33s|%-s\n" "$user" "$attempts" "$ip"\ "$HOST" "$time";
    fi
  done
done

rm $LOG
