#!/bin/bash
#opis: skrypt pobierający obrazy
#nazwa pliku: img_downloader.sh

if [ $# -ne 3 ];
then
 echo "Użycie: $0 URL -d DIRECTORY"
 exit -1
fi

while [ $# -gt 0 ]
do
 case $1 in
 -d) shift; directory=$1; shift;;
 *) url=$1; shift;;
 esac
done

echo "URL: $url"
echo "Folder: $directory"

mkdir -p $directory;
baseurl=$(echo $url | egrep -o "https?://[a-z.\-]+")
echo Pobieranie $url
curl -s $url | egrep -o "<img src=[^>]*>" | 
sed 's/<img src=\"\([^"]*\).*/\1/g' |
sed "s,^/,$baseurl/," > /tmp/$$.list
cd $directory;
while read filename;
do
 echo Pobieranie  $filename
 curl -s -O "$filename" --silent
done < /tmp/$$.list
