<%@taglib uri="http://java.sun.com/jsp/jstl/core" prefix="c"%>
<%@ taglib uri="http://www.springframework.org/security/tags"
	prefix="security"%>

<html>
<head>
<title>Lista lokat</title>
<style type="text/css">
.border {
	border-width: 1px;
	border-style: solid;
	border-collapse: collapse;
}

.td,.th {
	border: 1px solid;
	font-family: 'arial';
	font-size: 12px;
}

.a {
	font-family: 'arial';
	font-size: 12px;
}
</style>
</head>
<body>
	<form name="fixedDepositList" method="POST"
		action="${pageContext.request.contextPath}/fixedDeposit?fdAction=createFDForm">
		<table align="left" style="padding-left: 300px;">
			<tr>
				<td style="font-family: 'arial'; font-size: 12px; font-weight: bold"
					align="right"><a
					href="${pageContext.request.contextPath}/j_spring_security_logout">Wyloguj</a>
					<p>
						Użytkownik:
						<security:authentication property="principal.username" />
					</p></td>
			</tr>
			<tr>
				<td
					style="font-family: 'arial'; font-size: 16px; font-weight: bold;">Lista lokat</td>
			</tr>
			<tr>
				<td>&nbsp;</td>
			</tr>
			<tr>
				<td>
					<table class="border" cellpadding="10">
						<tr bgcolor="#99CCFF">
							<th class="th">ID</th>
							<security:authorize access="hasRole('ROLE_ADMIN')">
								<th class="th">Klient</th>
							</security:authorize>
							<th class="th">Wysokość lokaty</th>
							<th class="th">Czas trwania</th>
							<th class="th">E-mail</th>
							<th class="th">Operacja</th>
						</tr>
						<c:forEach items="${fdList}" var="fixedDeposit">
							<tr>
								<td class="td"><c:out value="${fixedDeposit.id}" /></td>
								<security:authorize access="hasRole('ROLE_ADMIN')">
									<td class="td"><c:out value="${fixedDeposit.customerId}" /></td>
								</security:authorize>
								<td class="td"><c:out value="${fixedDeposit.depositAmount}" /></td>
								<td class="td"><c:out value="${fixedDeposit.tenure}" /></td>
								<td class="td"><c:out value="${fixedDeposit.email}" /></td>
								<td class="td"><security:authorize
										access="hasRole('ROLE_CUSTOMER')">
										<a
											href="${pageContext.request.contextPath}/fixedDeposit?fdAction=view&fixedDepositId=${fixedDeposit.id}"
											style="color: green">Edytuj</a>
									</security:authorize> <security:authorize access="hasRole('ROLE_ADMIN')">
										<a
											href="${pageContext.request.contextPath}/fixedDeposit?fdAction=close&fixedDepositId=${fixedDeposit.id}"
											style="color: green">Zamknij</a>
									</security:authorize></td>
							</tr>
						</c:forEach>
					</table>
				</td>
			</tr>
			<tr align="center">
				<td><input type="submit" value="Załóż nową lokatę" /></td>
			</tr>
		</table>
	</form>
</body>
</html>