package sample.spring.chapter06.bankapp.service;

import javax.inject.Inject;
import javax.inject.Named;

import org.apache.log4j.Logger;

import sample.spring.chapter06.bankapp.dao.CustomerRequestDao;
import sample.spring.chapter06.bankapp.domain.CustomerRequestDetails;

@Named(value = "customerRequestService")
public class CustomerRequestServiceImpl implements CustomerRequestService {
	private static Logger logger = Logger
			.getLogger(CustomerRequestServiceImpl.class);
	private CustomerRequestDetails customerRequestDetails;
	private CustomerRequestDao customerRequestDao;

	@Inject
	public CustomerRequestServiceImpl(
			CustomerRequestDetails customerRequestDetails,
			CustomerRequestDao customerRequestDao) {
		logger.info("Utworzono egzemplarz CustomerRequestServiceImpl.");
		this.customerRequestDetails = customerRequestDetails;
		this.customerRequestDao = customerRequestDao;
	}

	@Override
	public void submitRequest(String requestType, String requestDescription) {
		// Utworzenie egzemplarza UserRequestDetails i jego zapis.
		customerRequestDao.submitRequest(customerRequestDetails);
	}

}
