package sample.spring.chapter04.bankapp;

import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import sample.spring.chapter04.bankapp.domain.FixedDepositDetails;
import sample.spring.chapter04.bankapp.service.CustomerRequestService;
import sample.spring.chapter04.bankapp.service.FixedDepositService;

public class BankApp {
	private static Logger logger = Logger.getLogger(BankApp.class);

	public static void main(String args[]) throws Exception {
		ApplicationContext context = new ClassPathXmlApplicationContext(
				"classpath:META-INF/spring/applicationContext.xml");

		FixedDepositService fixedDepositService = (FixedDepositService) context
				.getBean("service");

		fixedDepositService.createFixedDeposit(new FixedDepositDetails(101,
				10000, 60, "nazwa-użytkownika@nazwa-domeny.pl"));

		logger.info("Rozpoczęcie pracy z CustomerRequestService");
		CustomerRequestService customerRequestService_1 = context
				.getBean(CustomerRequestService.class);
		customerRequestService_1.submitRequest("checkBookRequest",
				"Żądanie przysłania 50-stronicowej książeczki czekowej");
		customerRequestService_1.submitRequest("checkBookRequest",
				"Żądanie przysłania 100-stronicowej książeczki czekowej");
		customerRequestService_1.submitRequest("checkBookRequest",
				"Żądanie przysłania 150-stronicowej książeczki czekowej");
		customerRequestService_1.submitRequest("checkBookRequest",
				"Żądanie przysłania 200-stronicowej książeczki czekowej");
		logger.info("Zakończenie pracy z CustomerRequestService");
	}
}
