package sample.spring.chapter09.bankapp.service;

import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import sample.spring.chapter09.bankapp.dao.FixedDepositDao;
import sample.spring.chapter09.bankapp.domain.FixedDepositDetails;

@Service(value = "fixedDepositService")
public class FixedDepositServiceImpl implements FixedDepositService {
	private static Logger logger = Logger
			.getLogger(FixedDepositServiceImpl.class);

	@Autowired
	private FixedDepositDao fixedDepositDao;

	public void createFixedDeposit(final FixedDepositDetails fdd)
			throws Exception {
		logger.info("Wywołano metodę createFixedDeposit().");
		fixedDepositDao.createFixedDeposit(new FixedDepositDetails(1, 100, 12, "nazwa-domeny@adres-email.pl"));
	}

	@Override
	public FixedDepositDetails getFixedDeposit(int fixedDepositId) {
		logger.info("Metoda getFixedDeposit() została wywołana wraz z fixedDepositId "
				+ fixedDepositId);
		return fixedDepositDao.getFixedDeposit(fixedDepositId);
	}
}
