package sample.spring.chapter06.bankapp;

import org.apache.log4j.Logger;
import org.springframework.context.ApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

import sample.spring.chapter06.bankapp.domain.FixedDepositDetails;
import sample.spring.chapter06.bankapp.service.FixedDepositService;

public class BankApp {
	private static Logger logger = Logger.getLogger(BankApp.class);

	public static void main(String args[]) throws Exception {
		ApplicationContext context = new ClassPathXmlApplicationContext(
				"classpath:META-INF/spring/applicationContext.xml");
		logger.info("Weryfikacja obiektu FixedDepositDetails za pomocą API Validation w Springu.");

		FixedDepositService fixedDepositService = (FixedDepositService) context
				.getBean("fixedDepositService");
		fixedDepositService.createFixedDeposit(new FixedDepositDetails(1, 0,
				12, "nazwa-użytkownika@nazwa-domeny.pl"));
		fixedDepositService.createFixedDeposit(new FixedDepositDetails(1, 1000,
				12, "nazwa-użytkownika@nazwa-domeny.pl"));

		logger.info("Weryfikacja obiektu FixedDepositDetails za pomocą specyfikacji JSR 303.");
		FixedDepositService fixedDepositServiceJsr303 = (FixedDepositService) context
				.getBean("fixedDepositServiceJsr303");
		fixedDepositServiceJsr303.createFixedDeposit(new FixedDepositDetails(1,
				0, 12, "nazwa-użytkownika@nazwa-domeny.pl"));
		fixedDepositServiceJsr303.createFixedDeposit(new FixedDepositDetails(1,
				1000, 12, "nazwa-użytkownika@nazwa-domeny.pl"));
	}
}
