package sample.spring.chapter05.bankapp.postprocessor;

import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;
import org.springframework.core.Ordered;

import sample.spring.chapter05.bankapp.common.DependencyResolver;
import sample.spring.chapter05.bankapp.common.MyApplicationContext;

public class DependencyResolutionBeanPostProcessor implements BeanPostProcessor,
		Ordered {
	private MyApplicationContext myApplicationContext;
	private int order;
	private static Logger logger = Logger
			.getLogger(DependencyResolutionBeanPostProcessor.class);
	
	public DependencyResolutionBeanPostProcessor() {
		logger.info("Utworzono egzemplarz DependencyResolutionBeanPostProcessor.");
	}
	
	public void setOrder(int order) {
		this.order = order;
	}
	
	@Override
	public int getOrder() {
		return order;
	}

	@Override
	public Object postProcessBeforeInitialization(Object bean, String beanName)
			throws BeansException {
		logger.info("Wywołanie metody postProcessBeforeInitialization() klasy DependencyResolutionBeanPostProcessor dla komponentu " + beanName + " typu " + bean.getClass());
		if (bean instanceof DependencyResolver) {
			((DependencyResolver) bean).resolveDependency(myApplicationContext);
		}
		return bean;
	}

	@Override
	public Object postProcessAfterInitialization(Object bean, String beanName)
			throws BeansException {
		logger.info("Wywołanie metody postProcessAfterInitialization() klasy DependencyResolutionBeanPostProcessor dla komponentu " + beanName + " typu " + bean.getClass());
		return bean;
	}

	public void setMyApplicationContext(
			MyApplicationContext myApplicationContext) {
		this.myApplicationContext = myApplicationContext;
	}

}
