package sample.spring.chapter05.bankapp.dao;

import org.apache.log4j.Logger;

import sample.spring.chapter05.bankapp.common.InstanceValidator;
import sample.spring.chapter05.bankapp.domain.FixedDepositDetails;

public class FixedDepositDaoImpl implements FixedDepositDao, InstanceValidator {
	private static Logger logger = Logger.getLogger(FixedDepositDaoImpl.class);
	private DatabaseConnection connection;

	public FixedDepositDaoImpl() {
		logger.info("Wywołanie konstruktora klasy FixedDepositDaoImpl.");
	}

	public void initializeDbConnection() {
		logger.info("Wywołanie metody initializeDbConnection() klasy FixedDepositDaoImpl.");
		connection = DatabaseConnection.getInstance();
	}

	public boolean createFixedDeposit(FixedDepositDetails fdd) {
		logger.info("Wywołanie metody createFixedDeposit() klasy FixedDepositDaoImpl.");
		// Zapis informacji o lokatach i zwrot wartości true.
		return true;
	}

	public void releaseDbConnection() {
		logger.info("Wywołanie metody releaseDbConnection() klasy FixedDepositDaoImpl.");
		connection.releaseConnection();
	}

	@Override
	public void validateInstance() {
		logger.info("Weryfikacja egzemplarza FixedDepositDaoImpl.");
		if(connection == null) {
			logger.error("Nie udało się pobrać egzemplarza DatabaseConnection.");
		}
	}
}
