package sample.spring.chapter02.bankapp.dao;

import java.util.HashMap;
import java.util.Map;

import org.apache.log4j.Logger;

import sample.spring.chapter02.bankapp.domain.FixedDepositDetails;

public class FixedDepositDaoImpl implements FixedDepositDao{
	private static Logger logger = Logger.getLogger(FixedDepositDaoImpl.class);
	
	private Map<Long, FixedDepositDetails> fixedDeposits = new HashMap<Long, FixedDepositDetails>();

	public FixedDepositDaoImpl() {
		logger.info("Inicjalizacja.");
	}
	
	public FixedDepositDetails getFixedDepositDetails(long id) {
		return fixedDeposits.get(id);
	}

	public boolean createFixedDeposit(FixedDepositDetails fdd) {
		fixedDeposits.put(fdd.getId(), fdd);
		return true;
	}
}
