# Copyright 2015 Sanford Ryza, Uri Laserson, Sean Owen and Joshua Wills
#
# Dodatkowe informacje są zawarte w pliku LICENSE

install.packages("rgl") # Tylko za pierwszym razem
library(rgl)

# Osobne odczytanie klastrów i danych
clusters_data <- read.csv(pipe("hadoop fs -cat /user/ds/sample/*"))
clusters <- clusters_data[1]
data <- data.matrix(clusters_data[-c(1)])
rm(clusters_data)

# Losowe projekcje 3D i normalizacja
random_projection <- matrix(data = rnorm(3*ncol(data)), ncol = 3)
random_projection_norm <- random_projection / sqrt(rowSums(random_projection*random_projection))

# Projekcja i określenie nowego zakresu danych
projected_data <- data.frame(data %*% random_projection_norm)

num_clusters <- nrow(unique(clusters))
palette <- rainbow(num_clusters)
colors = sapply(clusters, function(c) palette[c])
plot3d(projected_data, col = colors, size = 10)
