<?php
/*
 *Wtyczka Smarty
 *
 * Plik:     outputfilter.search_highlight.php
 * Typ:     filtr wynikowy
 * Nazwa:     search_highlight
 * Przeznaczenie:  Automatycznie podwietla sowa kluczowe uyte do wyszukiwania w przypadku, gdy
 *            uytkownik jest przekierowany do naszej witryny za porednictwem Google.
 * Instalacja:  Skopiowanie do katalogu plugin, a nastpnie uycie funkcji load_filter() w celu rcznego
 *            zaadowania wtyczki do systemu Smarty lub ustawienie zmiennej $autoload_filters
 *            
 */
require_once $smarty->_get_plugin_filepath('modifier', 'google_highlight');

function smarty_outputfilter_search_highlight($tpl_output, &$smarty)
 
{
    // sprawdzenie zawartoci nagwka HTTP_REFERER
    $referrer = getenv('HTTP_REFERER');
    if (!empty($referrer)) {
        $pieces = parse_url($referrer);
        // podwietlenie sw kluczowych uytych do wyszukiwania tylko wtedy, gdy 
        // uytkownik dotar do witryny z serwisu google.com
        if (stristr($pieces['host'], 'google.com')) {
            $params = explode('&', $pieces['query']);
            $query = array();
            foreach ($params as $param) {
                list($key, $value) = explode('=', $param);
                $query[$key] = urldecode($value);
            }
            // wykonywanie operacji tylko wtedy, gdy s dostpne 
            // sowa kluczowe uyte do wyszukiwania
            if (!empty($query['q'])) {
                $tpl_output = smarty_modifier_google_highlight($tpl_output,
                                                               $query['q']);
            }
        }
    }
    return $tpl_output;
}
?>
