<?php
/*
 *Wtyczka  Smarty
 * Plik:     function.calendar.php
 * Typ:     funkcja
 * Nazwa:     calendar
 * Przeznaczenie:  Wywietla widok kalendarza dla miesica
 *Przykad:  {calendar}
 *           {calendar month=4 year=2005}
 * Instalacja:  naley skopiowa do katalogu plug-in
 */
function smarty_function_calendar($params, &$smarty)
{
    extract($params);
    $html_result = '';

    $time = time();
    // w przypadku braku parametru 'month' 
    // uycie biecego miesica
    if (!isset($month)) {
        $month = date("n", $time);
    }
    // w przypadku braku parametru 'year',  
    // uycie biecego roku.
    if (!isset($year)) {
        $year = date("Y", $time);
    }
    // uniksowy znacznik czasu dla pierwszego dnia miesica
    $first_day_ts = mktime(0, 0, 0, $month, 1, $year);

    // utworzenie nagwka tabeli
    $html_result = '<table border="1">';
    $html_result .= '<tr>
                      <th width="14%">Niedziela</th>
                      <th width="14%">Poniedziaek</th>
                      <th width="14%">Wtorek</th>
                      <th width="14%">roda</th>
                      <th width="14%">Czwartek</th>
                      <th width="14%">Pitek</th>
                      <th width="14%">Sobota</th>
                    </tr>';
$current_day = 1;
    $current_week = 1;
    // total days within this month
    $total_days = date("t", $first_day_ts);
 
    // the week day number that the first day of the 
    // month falls on (Sunday = 0; Saturday = 6)
    $first_day = date("w", $first_day_ts);

    // loops through the days
    while ($current_day <= $total_days) {
        $html_result .= '<tr>';
        for ($i = 0; $i < 7; $i++) {
            if ((($current_week == 1)
                    && ($i >= $first_day)) ||
                    (($current_week > 1)
                    && ($current_day <= $total_days))) {
                $html_result .= '<td valign="top">';
                $html_result .= $current_day ;
                if ((isset($values)) && (!empty($values[$current_day]))) {
                    $html_result .= $values[$current_day];
                } else {
                    $html_result .= '&nbsp;';
                }
                $html_result .= '</td>';
                $current_day++;
            } else {
                $html_result .= '<td>&nbsp;</td>';
            }
        }
        $html_result .= '</tr>';
        $current_week++;
    }
    $html_result .= '</table>';

    print $html_result;
}
?>
