/*
 * socket.js — prosty przykład socket.io.
*/

/*jslint         node    : true, continue : true,
  devel  : true, indent  : 2,    maxerr   : 50,
  newcap : true, nomen   : true, plusplus : true,
  regexp : true, sloppy  : true, vars     : false,
  white  : true
*/
/*global */

// ------------ ROZPOCZĘCIE SEKCJI ZMIENNYCH ZAKRESU MODUŁU --------------
'use strict';
var
  countUp,

  http      = require( 'http'      ),
  express   = require( 'express'   ),
  socketIo  = require( 'socket.io' ),

  app       = express(),
  server    = http.createServer( app ),
  io        = socketIo.listen( server ),
  countIdx  = 0
  ;
// ------------- ZAKOŃCZENIE SEKCJI ZMIENNYCH ZAKRESU MODUŁU ---------------

// --------------- ROZPOCZĘCIE SEKCJI METOD NARZĘDZIOWYCH ------------------
countUp = function () {
  countIdx++;
  console.log( countIdx );
  io.sockets.send( countIdx );
};
// ---------------- ZAKOŃCZENIE SEKCJI METOD NARZĘDZIOWYCH  -------------------

// ------------- ROZPOCZĘCIE SEKCJI KONFIGURACJI SERWERA ---------------
app.configure( function () {
  app.use( express.static( __dirname + '/' ) );
});

app.get( '/', function ( request, response ) {
  response.redirect( '/socket.html' );
});
// -------------- ZAKOŃCZENIE SEKCJI KONFIGURACJI SERWERA ----------------

// ----------------- ROZPOCZĘCIE SEKCJI URUCHAMIANIA SERWERA -------------------
server.listen( 3000 );
console.log(
  'Serwer Express nasłuchuje na porcie %d w trybie %s',
   server.address().port, app.settings.env
);

setInterval( countUp, 1000 );
// ------------------ ZAKOŃCZENIE SEKCJI URUCHAMIANIA SERWERA --------------------
