/*
 * nodeunit_suite.js
  * Zestaw testów jednostkowych dla aplikacji SPA.
 *
 * Zestaw należy uruchomić za pomocą polecenia /nodeunit <nazwa_tego_pliku>/.
*/

/*jslint         node    : true, continue : true,
  devel  : true, indent  : 2,    maxerr   : 50,
  newcap : true, nomen   : true, plusplus : true,
  regexp : true, sloppy  : true, vars     : false,
  white  : true
*/
/*global $, spa */

// Moduły zewnętrzne i zmienne globalne.
global.jQuery = require( 'jquery' );
global.TAFFY  = require( './js/jq/taffydb-2.6.2.js' ).taffy;
global.$      = global.jQuery;
require( './js/jq/jquery.event.gevent-0.1.9.js' );

// Nasze moduły i zmienne globalne.
global.spa = null;
require( './js/spa.js'       );
require( './js/spa.util.js'  );
require( './js/spa.fake.js'  );
require( './js/spa.data.js'  );
require( './js/spa.model.js' );

// Rozpoczęcie /testAcct/  i testowanie inicjowania i logowania
var testAcct = function ( test ) {
  var $t, test_str, user, on_login,
    $defer = $.Deferred();

  // Ustawienie oczekiwanej liczby testów.
  test.expect( 1 );

  // Zdefiniowanie procedury obsługi dla zdarzenia 'spa-login'.
  on_login = function (){ $defer.resolve(); };

  // Inicjowanie.
  spa.initModule( null );
  spa.model.setDataMode( 'fake' );

  // Tworzenie obiektu jQuery i zdefiniowanie subskrypcji.
  $t = $('<div/>');
  $.gevent.subscribe( $t, 'spa-login', on_login );

  spa.model.people.login( 'Fred' );

  // Potwierdzenie, że użytkownik nie jest już anonimowy.
  user     = spa.model.people.get_user();
  test_str = 'Użytkownik nie jest już anonimowy';
  test.ok( ! user.get_is_anon(), test_str );

  // Deklarowanie zakończenia testu po ukończeniu procesu logowania.
  $defer.done( test.done );
};
// Zakończenie metody /testAcct/. initial setup and login

module.exports = { testAcct : testAcct };
