/*
 * chat.js — moduł zapewniający wymianę wiadomości na czacie.
*/

/*jslint         node    : true, continue : true,
  devel  : true, indent  : 2,    maxerr   : 50,
  newcap : true, nomen   : true, plusplus : true,
  regexp : true, sloppy  : true, vars     : false,
  white  : true
*/
/*global */

// ------------ ROZPOCZĘCIE SEKCJI ZMIENNYCH ZAKRESU MODUŁU --------------
'use strict';
var
  chatObj,
  socket = require( 'socket.io' ),
  crud   = require( './crud'    );
// ------------- ZAKOŃCZENIE SEKCJI ZMIENNYCH ZAKRESU MODUŁU ---------------

// ---------------- ROZPOCZĘCIE SEKCJI METOD PUBLICZNYCH ------------------
chatObj = {
  connect : function ( server ) {
    var io = socket.listen( server );

    // Rozpoczęcie konfiguracji io.
    io
      .set( 'blacklist' , [] )
      .of( '/chat' )
      .on( 'connection', function ( socket ) {
        socket.on( 'adduser',      function () {} );
        socket.on( 'updatechat',   function () {} );
        socket.on( 'leavechat',    function () {} );
        socket.on( 'disconnect',   function () {} );
        socket.on( 'updateavatar', function () {} );
      }
    );
    // Zakończenie konfiguracji io.

    return io;
  }
};

module.exports = chatObj;
// ----------------- ZAKOŃCZENIE SEKCJI METOD PUBLICZNYCH -------------------
