/*
 * routes.js — moduł zapewniający routing.
*/

/*jslint         node    : true, continue : true,
  devel  : true, indent  : 2,    maxerr   : 50,
  newcap : true, nomen   : true, plusplus : true,
  regexp : true, sloppy  : true, vars     : false,
  white  : true
*/
/*global */

// ------------ ROZPOCZĘCIE SEKCJI ZMIENNYCH ZAKRESU MODUŁU --------------
'use strict';
var configRoutes;
// ------------- ZAKOŃCZENIE SEKCJI ZMIENNYCH ZAKRESU MODUŁU ---------------

// ---------------- ROZPOCZĘCIE SEKCJI METOD PUBLICZNYCH ------------------
configRoutes = function ( app, server ) {
  app.get( '/', function ( request, response ) {
    response.redirect( '/spa.html' );
  });

  app.all( '/:obj_type/*?', function ( request, response, next ) {
    response.contentType( 'json' );
    next();
  });

  app.get( '/:obj_type/list', function ( request, response ) {
    response.send({ title: request.params.obj_type + ' lista' });
  });

  app.post( '/:obj_type/create', function ( request, response ) {
    response.send({ title: request.params.obj_type + ' utworzony' });
  });

  app.get( '/:obj_type/read/:id([0-9]+)',
    function ( request, response ) {
      response.send({
        title: request.params.obj_type
          + ' z id ' + request.params.id + ' znaleziony'
      });
    }
  );

  app.post( '/:obj_type/update/:id([0-9]+)',
    function ( request, response ) {
      response.send({
        title: request.params.obj_type
          + ' z id ' + request.params.id + ' zaktualizowany'
      });
    }
  );

  app.get( '/:obj_type/delete/:id([0-9]+)',
    function ( request, response ) {
      response.send({
        title: request.params.obj_type
          + ' z id ' + request.params.id + ' usunięty'
      });
    }
  );
};

module.exports = { configRoutes : configRoutes };
// ----------------- ZAKOŃCZENIE SEKCJI METOD PUBLICZNYCH -------------------
