//
//  TEMPLATE.C
//  Basic shell code for a Mercury/32 Daemon Process
//
//  Copyright (c) 1997-98, David Harris, All Rights Reserved.
//
//  To use this Daemon, follow these steps:
//
//  1: Using this shell, add the code to make your Daemon work. Also,
//     modify the "PROJECT" define in "MAKEFILE" to the name of your
//     Daemon, and adjust the filenames in "TEMPLATE.RSP".
//
//  2: Compile the DLL: the makefile enclosed will build the DLL using
//     Borland C v5.x or later. You may need to modify the makefile and
//     linker response file ("template.rsp") to point to directories that
//     are appropriate on your system.
//
//  3: Copy your Daemon's DLL into the same directory as your copy of
//     MERCURY.EXE
//
//  4: Using the "Aliases..." option on the Mercury "Configuration" menu,
//     add an alias that looks like this:
//
//        <daemon_name>@myhost.domain  ==  daemon:<daemon_name>.dll
//

#define STRICT
#include <windows.h>
#include <windowsx.h>
#include <stdio.h>
#include <string.h>
#include <alloc.h>
#include <stdlib.h>
#include <stdarg.h>
#include <time.h>
#include <io.h>            //  For "access"

#define USES_M_INTERFACE
#include "daemon.h"

HINSTANCE  hLibInstance;        // set in LibMain, used throughout the DLL
M_INTERFACE *mi;                // see the note below under "daemon" for this.

#pragma warn -par


static int jwritef (void *job, char *format, ...)
   {
   //  A convenience function for writing data into a job. It simply
   //  accepts a variable argument list, uses "vsprintf" to write it
   //  into a string, then writes that string out to the job. If you
   //  do a lot of message manipulation using the Mercury Daemon
   //  interface, this is probably a function you'll use a lot.

   va_list param;
   char buf [2048];
   int i;

   va_start (param, format);
   vsprintf (buf, format, param);
   i = strlen (buf);
   ji_add_data (job, buf);
   va_end (param);
   return i;
   }


short _export daemon (void *job, M_INTERFACE *m, char *address,
   char *parameter)
   {
   //  This is the function called by Mercury. Note that we have
   //  created a global variable of type "M_INTERFACE *" called
   //  "mi": doing this allows us to use the "convenience macros"
   //  in DAEMON.H for accessing Mercury internal functions.
   //
   //  At present, the return value from this function is unused
   //  except for Global Daemons (see DAEMON.TXT for more
   //  information on Global Daemons). You should always return
   //  0 from this function by default.

   mi = m;

   if ((mi->vmajor < 2) || ((mi->vmajor == 2) && (mi->vminor < 20)))
      return 0;

   //  Do your daemon processing here.

   return 0;
   }


short _export startup (M_INTERFACE *m, UINT_32 flags,
   char *name, char *parameter)
   {
   //  If you install your Daemon as a "Resident Daemon" (see section 4
   //  of "DAEMON.TXT"), then Mercury will call this function when it
   //  loads your Daemon at startup. This function is optional and can
   //  be removed if not required.
   //
   //  Returns:      1 - success
   //                0 - error: do not proceed with loading the Daemon.

   return 1;
   }


short _export shutdown (M_INTERFACE *m, DWORD code,
   char *name, char *parameter)
   {
   //  A Resident Daemon (see section 4 of DAEMON.TXT) can export this
   //  function if it wants a chance to clean up on exit. Mercury calls
   //  this function as part of its shutdown process, and does not
   //  continue shutting down until it returns. This function is only 
   //  called for Resident Daemons (including Global Daemons) - it is
   //  not called for normal "one-shot" Daemons.
   //
   //  "code" is unused and reserved for future use
   //
   //  The return value from this function is ignored at present
   //  and must be 0.

   return 0;
   }


short _export configure (M_INTERFACE *m, char *name, char *parameter)
   {
   //  If your Daemon has configuration services, then follow the
   //  directions in section 4 of "DAEMON.TXT" and add the service
   //  code that should handle the configuration here.
   //
   //  The return value from this function is ignored at present,
   //  and should be 1.

   return 1;
   }


//  DLLEntryPoint is the standard Win32 DLL entry point for the
//  module. Usually all we do in this function is store our
//  Instance handle for use in other places, but any reasonable
//  initialization processing can be done here as well.


BOOL WINAPI DllEntryPoint (HINSTANCE hInst, DWORD reason, LPVOID reserved)
   {
   WNDCLASS wc;

   if (reason == DLL_PROCESS_ATTACH)
      hLibInstance = hInst;

   return (TRUE);             // Initialization went OK
   }

