################################################
# Plik: mymonitor.pl                           #
# Opis: Ten skrypt pobiera argument            #
#       reprezentujcy adres URL witryny       #
# Format: perl mymonitor.pl http://www.xyz.com #
################################################
use threads;
use Benchmark;
use Time::HiRes qw(gettimeofday tv_interval);
use LWP::Simple;
use LWP::UserAgent;
use File::Path;
#Pobieranie strony do monitorowania
my $pageToMonitor = shift;
my $ua = new LWP::UserAgent;
my $res;
#Czyszczenie plikw tymczasowych
rmtree( './temp', {keep_root => 1} );
# Uruchomienie zegara
my $start_time = [ gettimeofday ];
$res = $ua->get("$pageToMonitor",':content_file' => "./temp/temp.dat");
# Zatrzymanie zegara
my $end_time = [ gettimeofday ];
my $elapsedtime = tv_interval($start_time,$end_time);
##### TWORZENIE PLIKW Z DANYMI #####################################
my ($sec,$min,$hour,$mday,$mon,$year,$wday,$yday,$isdst)
    = localtime time;
$year += 1900;
$mon++;
# Tworzenie pliku today.txt
open OUTPTR, ">>./report/today/today.txt";
print OUTPTR "$mday-$mon-$year $hour:$min:$sec;10;15;20;
$elapsedtime\n";
close OUTPTR;
# Tworzenie pliku month.txt
open OUTPTR, ">>./report/month/month.txt";
print OUTPTR "$mday-$mon-$year $hour:$min:$sec;10;15;20;
$elapsedtime\n";
close OUTPTR;
# Tworzenie pliku year.txt
open OUTPTR, ">>./report/year/year.txt";
print OUTPTR "$mday-$mon-$year $hour:$min:$sec;10;15;20;
$elapsedtime\n";
close OUTPTR;
# Tworzenie pliku historical.txt
open OUTPTR, ">>./report/historical/historical.txt";
print OUTPTR "$mday-$mon-$year $hour:$min:$sec;10;15;20;$elapsedtime\n";
close OUTPTR;