#!/usr/local/bin/perl

##############################################
# Plik: getRankings.pl                       #
# Opis: Skrypt ten odpytuje wyszukiwarki,    #
# aby wygenerowa raport dotyczcy rankingw #                      
##############################################

### Podstawowa konfiguracja
$numOfArgs = $#ARGV + 1;
$originalkeywordphrase = "";
$targeturl="";

if ( ($numOfArgs == 0) || ($numOfArgs == 1) || ($numOfArgs < 0)) {
    print ("\n\nWywoanie: perl getRanking.pl [DocelowyAdresURL] [SowoKluczowe]\n");
    print ("\nOR\n");
    print ("\nUsage: perl getRanking.pl [DocelowyAdresURL] [SowoKluczowe1] [SowoKluczowe2] ... [SowoKluczoweN]\n\n");
    exit(0);
}

$targeturl=$ARGV[0];

if ( $numOfArgs == 2){
    $originalkeywordphrase = $ARGV[1];
}else {
    foreach $argnum (1 .. $#ARGV) {
        $originalkeywordphrase = $originalkeywordphrase . " " . $ARGV[$argnum];

        #Usunicie spacji popprzedzajcych i kocowych
        $originalkeywordphrase =~ s/^\s+//;
        $originalkeywordphrase =~ s/\s+$//;
    }
}

$keywordphrase= $originalkeywordphrase;
$keywordphrase =~ s/([^A-Za-z0-9])/sprintf("%%%02X", ord($1))/seg;

# Zdefiniowanie rdowych adresw URL
$listingNo=100;

$gurl=
"http://www.google.com/search?num=$listingNo&hl=en&safe=off&q=$keywordphrase&sa=N";
$burl= "http://www.bing.com/search?q=$keywordphrase&first=1&count=100&";

### Pobranie czci stron z wynikami wyszukiwania
# Pogranie stron z wynikami wyszukiwania Google
$gserp = `wget "$gurl"
--user-agent="Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
--output-document="gserp.html" --cookies=off`;
# Pogranie stron z wynikami wyszukiwania Bing
$bserp = `wget "$burl"
--user-agent="Mozilla/4.0 (compatible; MSIE 7.0; Windows NT 6.0)"
--output-document="bserp.html" --cookies=off`;

### Analizowanie
$googlePositionNumber = getPosition ($targeturl, "google");
$bingSearchPositionNumber = getPosition ($targeturl, "bing");

# Raport
##########################
print "\nRaport podsumowujcy ranking\n";
print "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n";
print "Sowo kluczowe/fraza: $originalkeywordphrase\n";
print "Docelowy adres URL: $targeturl\n";
print "~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~\n";
print " Google.....: $googlePositionNumber\n";

if($bingSearchPositionNumber ne "nie znaleziono"){
    $cntAdjusted = $bingSearchPositionNumber + 1;
    print "Bing: $cntAdjusted\n";
}else{
    print "Bing: $bingSearchPositionNumber\n";
}
print "\nUwaga: Sprawd z okrelon z wyszukiwark, aby zweryfikowa poprawno wyniku.\n";

##### PODPROGRAMY ####################################
sub getContent {
    $filename=shift;
    open INPUT, "<$filename";
    undef $/;
    $content = <INPUT>;
    close INPUT;
    #Przywracanie
    $/ = "\n";
    
    #Zamiana znaku nowego wiersza znakiem spacjisubstitute new line character with space character
    $content =~ s/\n/ /g;
    #Zamiana cudzysoww niczym
    $content =~ s/\"//g;
    
    #Czyszczenie bing
    $content =~ s/<strong>//g;
    $content =~ s/<\/strong>//g;

    $content =~ s/<cite>//g;
    $content =~ s/<\/cite>//g;

    return $content;
}

sub getPosition {
    $targeturl= shift;
    $se = shift;
    @tokens = ();
    $offset = 0;
    if($se eq "google") {
        $gcontent = getContent("gserp.html");
        @tokens = split(/h3 class=r/, $gcontent);
    } elsif($se eq "bing") {
        $bcontent = getContent("bserp.html");
        @tokens = split(/sa_cc/, $bcontent);
        $offset=2;
    }

    $mastercnt = "nie znaleziono";
    $cnt=0;
    $foundFlag = "nie";
    print "liczba tokenw:". $#tokens;
    foreach $token (@tokens) {
    #print "\ntoken: $token";
    if ($token =~ /$targeturl/gi) {
        if($foundFlag eq "nie") {
            $mastercnt = $cnt - $offset;
        } else {
            $mastercnt = "" . $mastercnt . "," . $cnt;
        }
        #print "\nDOPASOWANIE: $targeturl cnt: $cnt $mastercnt\n token";
        #Pobieranie wstecznej pozycji zwrotnej dopasowania
        $foundFlag = "tak";
    }
    $cnt = $cnt + 1;
}
return $mastercnt;
}
