import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.By;

import org.junit.*;
import org.junit.runner.*;
import org.junit.runners.*;
import org.junit.runners.Parameterized.Parameters;

import static org.junit.Assert.*;

import java.sql.*;
import java.util.*;

@RunWith(value = Parameterized.class)
public class DbTestData {

	private static WebDriver driver;

	private String height;
	private String weight;
	private String bmi;
	private String bmiCategory;

	@Parameters
	public static Collection testData() throws Exception {
		return getTestData("C:\\BmiTesting.mdb",
				"SELECT Height, Weight, Bmi, Category FROM TestData");
	}

	public DbTestData(String height, String weight, String bmi,
			String bmiCategory) {
		this.height = height;
		this.weight = weight;
		this.bmi = bmi;
		this.bmiCategory = bmiCategory;
	}

	public static Collection<String[]> getTestData(String mdbFile,
			String sqlQuery) throws Exception {
		ArrayList<String[]> records = new ArrayList<String[]>();

		Class.forName("sun.jdbc.odbc.JdbcOdbcDriver");
		String myDB = "jdbc:odbc:Driver={Microsoft Access Driver (*.mdb)};DBQ="
				+ mdbFile;
		Connection conn = DriverManager.getConnection(myDB, "", "");

		Statement stmt = null;
		ResultSet rs = null;

		stmt = conn.createStatement(ResultSet.TYPE_SCROLL_INSENSITIVE,
				ResultSet.CONCUR_UPDATABLE);

		rs = stmt.executeQuery(sqlQuery);
		ResultSetMetaData rsMetaData = rs.getMetaData();

		int cols = rsMetaData.getColumnCount();

		while (rs.next()) {

			String fields[] = new String[cols];
			int col = 0;
			for (int colIdx = 1; colIdx <= cols; colIdx++) {
				fields[col] = rs.getString(colIdx);
				col++;
			}
			records.add(fields);
		}

		rs.close();
		stmt.close();
		conn.close();

		return records;
	}

	@BeforeClass
	public static void setUp() throws Exception {
		// Utwórz nowy egzemplarz sterownika przeglądarki Firefox
		driver = new FirefoxDriver();
		driver.get("http://dl.dropbox.com/u/55228056/bmicalculator.html");
	}

	@Test
	public void testBMICalculator() {
		WebElement heightField = driver.findElement(By.name("heightCMS"));
		heightField.clear();
		heightField.sendKeys(this.height);

		WebElement weightField = driver.findElement(By.name("weightKg"));
		weightField.clear();
		weightField.sendKeys(this.weight);

		WebElement calculateButton = driver.findElement(By.id("Oblicz"));
		calculateButton.click();

		WebElement bmiLabel = driver.findElement(By.name("bmi"));
		assertEquals(this.bmi, bmiLabel.getAttribute("value"));

		WebElement bmiCategoryLabel = driver.findElement(By
				.name("bmi_category"));
		assertEquals(this.bmiCategory, bmiCategoryLabel.getAttribute("value"));
	}

	@AfterClass
	public static void tearDown() throws Exception {
		// Zamknij przeglądarkę
		driver.quit();
	}
}

