package com.secookbook.examples.chapter03;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.By;
import org.openqa.selenium.support.ui.Select;
 
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import static org.junit.Assert.*;

public class SelectTest {

	private WebDriver driver;

	@Before
	public void setUp() {
		driver = new FirefoxDriver();
		driver.get("http://cookbook.seleniumacademy.com/Config.html");
	}

	@Test
	public void testDropdown() {

		// Pobranie menu rozwijanego jako obiektu Select na podstawie atrybutu name
		Select make = new Select(driver.findElement(By.name("make")));

		// Sprawdzenie, czy menu rozwijane obsługuje wybór wielokrotny
		assertFalse(make.isMultiple());
		// Sprawdzenie, czy menu rozwijane ma cztery opcje wyboru
		assertEquals(4, make.getOptions().size());

		// Sprawdzenie, czy w rozwijanym menu są oczekiwane wartości zgodne z elementami tablicy
		List<String> exp_options = Arrays.asList("BMW", "Mercedes", "Audi",
				"Honda");
		List<String> act_options = new ArrayList<String>();

		// Pobranie wartości opcji rozwijanego menu za pomocą metody getOptions()
		for(WebElement option : make.getOptions()) {
			act_options.add(option.getText());
		}

		// Sprawdzenie, czy elementy tablicy opcji oczekiwanych i rzeczywistych do siebie pasują
		assertArrayEquals(exp_options.toArray(), act_options.toArray());

		// Klasa Select pozwala zaznaczyć opcję rozwijanego menu na podstawie wyświetlanego tekstu
		make.selectByVisibleText("Honda");
		assertEquals("Honda", make.getFirstSelectedOption().getText());

		// można także zaznaczyć opcję w menu rozwijanym przy użyciu wartości atrybutu
		make.selectByValue("audi");
		assertEquals("Audi", make.getFirstSelectedOption().getText());

		// opcję w menu rozwijanym można też wybrać przy użyciu indeksu
		make.selectByIndex(0);
		assertEquals("BMW", make.getFirstSelectedOption().getText());
	}

	@Test
	Public void testMultipleSelectList() {}
		// Pobranie listy jako obiektu Select na podstawie atrybutu name
		Select color = new Select(driver.findElement(By.name("color")));

		// Sprawdzenie, czy lista pozwala na wybór wielokrotny
		assertTrue(color.isMultiple());

		// Sprawdzenie, czy lista zawiera pięć opcji do wyboru
		assertEquals(5, color.getOptions().size());

		// Zaznaczenie wielu opcji na liście na podstawie widocznego tekstu
		color.selectByVisibleText("Czarny");
		color.selectByVisibleText("Czerwony");
		color.selectByVisibleText("Srebrny");

		// Sprawdzenie, czy na liście zaznaczono 3 opcje
		assertEquals(3, color.getAllSelectedOptions().size());

		// Sprawdzenie, czy na liście zaznaczono wiele opcji zgodnie z zawartością tablicy
		List<String> exp_sel_options = Arrays.asList("Czarny", "Czerwony", "Srebrny");
		List<String> act_sel_options = new ArrayList<String>();

		for (WebElement option : color.getAllSelectedOptions()) {
			act_sel_options.add(option.getText());
		}

		// Sprawdzenie, czy elementy tablicy opcji oczekiwanych i rzeczywistych do siebie pasują
		assertArrayEquals(exp_sel_options.toArray(), act_sel_options.toArray());

		// Anulowanie zaznaczenia opcji na podstawie widocznego tekstu
		color.deselectByVisibleText("Srebrny");
		// Sprawdzenie liczby zaznaczonych opcji
		assertEquals(2, color.getAllSelectedOptions().size());

		// Anulowanie zaznaczenia opcji na podstawie atrybutu value
		color.deselectByValue("rd");
		// Sprawdzenie liczby zaznaczonych opcji
		assertEquals(1, color.getAllSelectedOptions().size());

		// Anulowanie zaznaczenia opcji przy użyciu indeksu opcji
		color.deselectByIndex(0);
		// Sprawdzenie liczby zaznaczonych opcji
		assertEquals(0, color.getAllSelectedOptions().size());
	}

	@After
	public void tearDown() {
		driver.quit();
	}
}

