package com.secookbook.examples.chapter08.tests;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;

import static org.junit.Assert.*;

import com.secookbook.examples.chapter08.pageobjects.BmiCalcPage;
import com.secookbook.examples.chapter08.pageobjects.CopyOfBmiCalcPage;

public class CopyOfBmiCalculatorTests {

	private WebDriver driver;

	@Before
	public void setUp() {
		driver = new ChromeDriver();
		driver.get("http://cookbook.seleniumacademy.com/bmicalculator.html");
	}

	@Test
	public void testBmiCalculation() {
		//Utworzenie egzemplarza klasy strony Kalkulator Bmi
		//i przekazanie obiektu driver
		CopyOfBmiCalcPage bmiCalcPage = new CopyOfBmiCalcPage(driver);
		
		//Ustawienie wzrostu
		bmiCalcPage.setHeight("181");
		
		//Ustawienie wagi
		bmiCalcPage.setWeight("80");
		
		//Kliknięcie przycisku Oblicz
		bmiCalcPage.calculateBmi();

		//Zweryfikowanie wartości BMI i kategorii Bmi
		assertEquals("24.4", bmiCalcPage.getBmi());
		assertEquals ("Waga normalna", bmiCalcPage.getBmiCategory());
	}
	
	@After
	public void tearDown() {
		driver.quit();
	}
}

