package com.secookbook.examples.chapter09;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.WebElement;

import org.junit.*;
import static org.junit.Assert.assertEquals;

public class ObjectMapTest {

	private WebDriver driver;
	private ObjectMap map;

	@Before
	public void setUp() throws Exception {
		// Utwórz nowy egzemplarz sterownika przeglądarki Firefox
		driver = new FirefoxDriver();
		driver.get("http://cookbook.seleniumacademy.com/bmicalculator.html");
	}

	@Test
	public void testBmiCalculator() {
		// Pobierz plik mapy obiektów
		map = new ObjectMap("src/test/resources/objectmap/objectmap.properties");

		// Pobranie wartości elementu „wzrost”
		WebElement height = driver.findElement(map.getLocator("height_field"));
		;
		height.sendKeys("181");

		// Pobranie wartości elementu „waga”
		WebElement weight = driver.findElement(map.getLocator("weight_field"));
		weight.sendKeys("80");

		//Kliknięcie przycisku Oblicz
		WebElement calculateButton = driver.findElement(map
				.getLocator("calculate_button"));
		calculateButton.click();

		// Sprawdzenie Bmi
		WebElement bmi = driver.findElement(map.getLocator("bmi_field"));
		assertEquals("24.4", bmi.getAttribute("value"));
	}

	@After
	public void tearDown() throws Exception {
		// Zamknięcie przeglądarki
		driver.quit();
	}
}

