package com.secookbook.examples.chapter03;

import java.util.List;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.By;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import static org.junit.Assert.*;

public class RadioButtonTest {
	private WebDriver driver;

	@Before
	public void setUp() {
		driver = new FirefoxDriver();
		driver.get("http://cookbook.seleniumacademy.com/Config.html");
	}

	@Test
	public void testRadioButton() {
		// Utworzenie reprezentacji przełącznika w postaci obiektu WebElement na podstawie jego atrybutu value
		WebElement petrol = driver.findElement(By
				.xpath("//input[@value='Benzyna']"));

		// Sprawdzenie, czy przełącznik jest już zaznaczony. W przeciwnym razie zaznaczamy go
		// przez wywołanie metody click()
		if (!petrol.isSelected()) {
			petrol.click();
		}

		// Zweryfikowanie, czy przełącznik jest zaznaczony
		assertTrue(petrol.isSelected());

		// Można również uzyskać listę wszystkich przełączników z grupy opcji
		// W tym celu należy przekazać identyfikator grupy opcji do metody findElements()
		List<WebElement> fuel_type = driver.findElements(By.name("fuel_type"));
		for (WebElement type : fuel_type) {
			// Wyszukaj przełącznik Diesel w grupie opcji i zaznacz go
			if (type.getAttribute("value").equals("Diesel")) {
				if(!type.isSelected()) {
					type.click();
				}
				assertTrue(type.isSelected());
				break;
			}
		}
	}

	@After
	public void tearDown() {
		driver.quit();
	}
}

