package com.secookbook.examples.chapter09;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.File;

import javax.imageio.ImageIO;

import org.openqa.selenium.OutputType;
import org.openqa.selenium.Point;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.internal.WrapsDriver;
import org.openqa.selenium.JavascriptExecutor;

public class WebElementExtender {

	public static void setAttribute(WebElement element, String attributeName,
			String value) {
		WrapsDriver wrappedElement = (WrapsDriver) element;

		JavascriptExecutor driver = (JavascriptExecutor) wrappedElement
				.getWrappedDriver();
		driver.executeScript(
				"arguments[0].setAttribute(arguments[1], arguments[2])",
				element, attributeName, value);
	}

	public static void highlightElement(WebElement element) {
		for (int i = 0; i < 5; i++) {
			WrapsDriver wrappedElement = (WrapsDriver) element;
			JavascriptExecutor driver = (JavascriptExecutor) wrappedElement
					.getWrappedDriver();
			driver.executeScript(
					"arguments[0].setAttribute('style', arguments[1]);",
					element, "color: green; border: 2px solid green;");
			driver.executeScript(
					"arguments[0].setAttribute('style', arguments[1]);",
					element, "");
		}
	}

	public static File captureElementPicture(WebElement element)
			throws Exception {

		// Pobranie obiektu WrapsDriver na podstawie obiektu WebElement
		WrapsDriver wrapsDriver = (WrapsDriver) element;

		// Wykonanie zrzutu ekranu na podstawie obiektu WebElement
		File screen = ((TakesScreenshot) wrapsDriver.getWrappedDriver())
				.getScreenshotAs(OutputType.FILE);

		// Utworzenie egzemplarza obiektu BufferedImage na podstawie wykonanego zrzutu
		BufferedImage img = ImageIO.read(screen);

		// Pobranie wartości szerokości i wysokości dla obiektu WebElement za pomocą metody getSize()
		int width = element.getSize().getWidth();
		int height = element.getSize().getHeight();

		// Utworzenie prostokąta za pomocą wartości szerokości i wysokości
		Rectangle rect = new Rectangle(width, height);

		// Pobranie lokalizacji obiektu WebElement i utworzenie obiektu Point
		// W ten sposób uzyskamy współrzędne X i Y obiektu WebElement
		Point p = element.getLocation();

		// Utworzenie obrazu elementu z wykorzystaniem jego lokalizacji i rozmiaru
		// W ten sposób uzyskamy dane obrazu specyficzne dla obiektu WebElement
		BufferedImage dest = img.getSubimage(p.getX(), p.getY(), rect.width,
				rect.height);

		// Zapisanie danych obrazu elementu do obiektu File
		ImageIO.write(dest, "png", screen);

		// Zwrócenie obiektu File z danymi obrazu
		return screen;
	}
}

