package com.secookbook.examples.chapter09;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;

import org.openqa.selenium.By;
import static org.junit.Assert.*;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;

public class JQueryUITabWidgetTest {

	private WebDriver driver;

	@Before
	public void setUp() {
		driver = new FirefoxDriver();
		driver.get("http://cookbook.seleniumacademy.com/jQueryUITabDemo.html");
	}

	@Test
	public void testjQueryUITabWidget() {

		JQueryUITab tab = new JQueryUITab(driver.findElement(By
				.cssSelector("div[id=MyTab][class^=ui-tabs]")));

		// Zweryfikowanie, czy widget Tab zawiera 3 zakładki
		assertEquals(3, tab.getTabCount());

		//Zweryfikowanie, czy zaznaczono zakładkę Strona główna
		assertEquals("Strona główna", tab.getSelectedTab());

		//Zaznaczenie zakładki Opcje i sprawdzenie, czy jest zaznaczona
		tab.selectTab("Opcje");
		assertEquals("Opcje", tab.getSelectedTab());

		//Zaznaczenie zakładki Administracja i sprawdzenie, czy jest zaznaczona
		tab.selectTab("Administracja");
		assertEquals("Administracja", tab.getSelectedTab());

		//Zaznaczenie zakładki Strona główna
		tab.selectTab("Strona główna");
	}

	@After
	public void tearDown() {
		// Zamknięcie przeglądarki
		driver.quit();
	}
}

