package com.secookbook.examples.chapter08.tests;

import org.junit.Test;

import com.secookbook.examples.chapter08.pageobjects.Browser;
import com.secookbook.examples.chapter08.pageobjects.HomePage;
import com.secookbook.examples.chapter08.pageobjects.SearchResults;

import static org.junit.Assert.*;

public class SearchTest {

	@Test
	public void testProductSearch() {
		try {
			// Utworzenie egzemplarza strony głównej
			HomePage homePage = new HomePage(Browser.driver());

			// Przejście na stronę główną
			homePage.get();

			// Wyszukiwanie frazy 'phones', metoda searchInStore zwróci wyniki w
			// SearchResults
			SearchResults searchResult = homePage.Search().searchInStore(
					"phones");

			// Zweryfikowanie, czy wyniki wyszukiwania zawierają 2 produkty
			assertEquals(2, searchResult.getProducts().size());
			assertTrue(searchResult.getProducts().contains(
					"MADISON OVEREAR HEADPHONES"));
		} finally {
			Browser.close();
		}
	}
}

