package com.secookbook.examples.chapter04;

import static org.junit.Assert.*;

import java.util.concurrent.TimeUnit;

import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.openqa.selenium.By;
import org.openqa.selenium.Cookie;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.support.ui.Select;

public class CookiesTest {

	WebDriver driver;

	@Before
	public void setUp() throws Exception {
		driver = new ChromeDriver();
		driver.manage().timeouts().implicitlyWait(10, TimeUnit.SECONDS);
		
	}

	@After
	public void tearDown() throws Exception {
		driver.quit();
	}

	@Test
	public void testCookies() {
		driver.get("http://demo.magentocommerce.com/");
		
		// Utworzenie reprezentacji rozwijanego menu wyboru języka w postaci egzemplarza klasy Select.
		Select language = new Select(driver.findElement(By
				.id("select-language")));

		// Sprawdzenie, czy domyślnie zaznaczona opcja to język polski.
		assertEquals("Polski", language.getFirstSelectedOption().getText());

		// Zmienna storeCookie powinna mieć wartość null.
		Cookie storeCookie = driver.manage().getCookieNamed("store");
		assertEquals(null, storeCookie);

		// Zaznacz opcję przy użyciu metody SelectByVisibleText.
		language.selectByVisibleText("English");

		// Zmienna storeCookie powinna zawierać informację o wybranym języku.
		storeCookie = driver.manage().getCookieNamed("store");
		assertEquals("english", storeCookie.getValue());
	}
}

