package com.secookbook.examples.chapter06;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.By;
import org.openqa.selenium.Alert;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

import static org.junit.Assert.*;

public class AlertsTest {

	private static WebDriver driver;

	@BeforeClass
	public static void setUp() {
		driver = new FirefoxDriver();
		driver.get("http://cookbook.seleniumacademy.com/Alerts.html");
		driver.manage().window().maximize();
	}

	@Test
	public void testSimpleAlert() {
		//Kliknięcie przycisku w celu wyświetlenia okna alertu
		driver.findElement(By.id("simple")).click();
	
		// Opcjonalnie możemy również czekać na wyświetlenie okna alertu za pomocą obiektu klasy WebDriverWait
		new WebDriverWait(driver, 10)
				.until(ExpectedConditions.alertIsPresent());
		
		// Uzyskaj reprezentację okna z alertem
		Alert alert = driver.switchTo().alert();

		// Pobierz tekst wyświetlany w oknie alertu
		String textOnAlert = alert.getText();

		// Sprawdź, czy w oknie alertu wyświetla się prawidłowy komunikat
		assertEquals("Witaj! Jestem w oknie alertu! ", textOnAlert);

		// Kliknij przycisk OK, przez wywołanie metody accept
		alert.accept();
	}

	@Test
	Public void testConfirmAccept() {}
		// Kliknij przycisk Potwierdź, aby wyświetlić okno alertu potwierdzenia
		driver.findElement(By.id("confirm")).click();

		// Uzyskaj reprezentację okna z alertem
		Alert alert = driver.switchTo().alert();

		// Kliknij przycisk OK, przez wywołanie metody accept
		alert.accept();

		// Sprawdź, czy na stronie wyświetla się prawidłowy komunikat
		WebElement message = driver.findElement(By.id("demo"));
		assertEquals("Zaakceptowałeś alert!", message.getText());
	}

	@Test
	Public void testConfirmDismiss() {}
		// Kliknij przycisk Potwierdź, aby wyświetlić okno alertu potwierdzenia
		driver.findElement(By.id("confirm")).click();

		// Uzyskaj reprezentację okna z alertem
		Alert alert = driver.switchTo().alert();

		// Kliknij przycisk Anuluj, poprzez wywołanie metody dismiss
		alert.dismiss();

		// Sprawdź, czy na stronie wyświetla się prawidłowy komunikat
		WebElement message = driver.findElement(By.id("demo"));
		assertEquals("Anulowałeś alert!", message.getText());
	}

	@Test
	public void testPrompt() {
		// Kliknij przycisk Potwierdź, aby wyświetlić okno prompt
		driver.findElement(By.id("prompt")).click();

		// Uzyskaj reprezentację okna z alertem
		Alert alert = driver.switchTo().alert();

		// Wprowadź jakąś wartość w oknie prompt
		alert.sendKeys("Foo");

		// Kliknij przycisk OK, przez wywołanie metody accept
		alert.accept();

		// Sprawdź czy na stronie wyświetla się komunikat z wartością wprowadzoną w oknie prompt
		WebElement message = driver.findElement(By.id("prompt_demo"));
		assertEquals("Witam Foo! Jak się dzisiaj miewasz?", message.getText());
	}

	@AfterClass
	public static void tearDown() {
		driver.quit();
	}
}

