package com.secookbook.examples.chapter05;

import static org.junit.Assert.*;

import org.junit.Test;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.support.ui.ExpectedCondition;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;

public class ExplicitWaitTest {

	@Test
	public void testExplicitWait() {

		WebDriver driver = new FirefoxDriver();
		// Uruchomienie przykładowej aplikacji Ajax
		driver.get("http://cookbook.seleniumacademy.com/AjaxDemo.html");

		try {
			driver.findElement(By.linkText("Strona 4")).click();
			WebElement message = new WebDriverWait(driver, 5)
					.until(new ExpectedCondition<WebElement>(){
						public WebElement apply(WebDriver d) {
							return d.findElement(By.id("page4"));
						}
					});
			assertTrue(message.getText().contains("Nunc nibh tortor"));
		} finally {
			driver.quit();
		}
	}

	@Test
	public void testExplicitWaitByTitle() {

		WebDriver driver = new FirefoxDriver();
		driver.get("http://www.google.com");

		try {
			WebElement query = driver.findElement(By.name("q"));
			query.sendKeys("selenium");
			query.submit();

			new WebDriverWait(driver, 10)
					.until(new ExpectedCondition<Boolean>() {
						public Boolean apply(WebDriver d) {
							return d.getTitle().toLowerCase()
									.startsWith("selenium");
						}
					});

			assertTrue(driver.getTitle().toLowerCase().startsWith("selenium"));
		} finally {
			driver.quit();
		}
	}

	@Test
	public void testExplicitWaitTitleContains() {
		//Przejdź do strony głównej Google
		WebDriver driver = new FirefoxDriver();
		driver.get("http://www.google.com");

		try {
			//Wprowadź termin do wyszukiwania i zatwierdź go
			WebElement query = driver.findElement(By.name("q"));
			query.sendKeys("selenium");
			query.click();

			//Utworzenie obiektu oczekiwania za pomocą klasy WebDriverWait.
			// Oczekiwanie do upływu limitu 10 sekund na aktualizację tytułu
			// wyszukiwaną frazą
			// Jeśli tytuł zaktualizowano w określonym limicie, test przejdzie do
			//następnego kroku zamiast czekać przez 10 sekund
			WebDriverWait wait = new WebDriverWait(driver, 10);
			wait.until(ExpectedConditions.titleContains("selenium"));

			//Sprawdzenie tytułu
			assertTrue(driver.getTitle().toLowerCase().startsWith("selenium"));
		} finally {
			driver.quit();
		}
	}
}

