package com.secookbook.examples.chapter03;

import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.By;

import static org.junit.Assert.*;
import org.junit.AfterClass;
import org.junit.BeforeClass;
import org.junit.Test;

public class ElementTests {

	static WebDriver driver;

	@BeforeClass
	public static void setUp() {
		driver = new ChromeDriver();
		driver.get("http://cookbook.seleniumacademy.com/DoubleClickDemo.html");
	}

	@Test
	public void testElementText() {
		// Pobranie wartości elementu message
		WebElement message = driver.findElement(By.id("message"));

		// Pobranie wartości tekstowej elementu message
		String messageText = message.getText();

		// Sprawdzenie, czy tekst elementu message zawiera
		// "Kliknij mnie, aby zmienić kolor"
		assertEquals ("Kliknij mnie, aby zmienić kolor", messageText);

		// Pobranie elementu area
		WebElement area = driver.findElement(By.id("area"));

		// Sprawdzenie, czy tekst elementu area wyświetla tekst "Tekst div/nTekst span"
		assertEquals("Tekst div\nTekst span", area.getText());
	}

	@Test
	public void testElementAttribute() {
		WebElement message = driver.findElement(By.id("message"));
		assertEquals("justify", message.getAttribute("align"));
	}

	@Test
	public void testElementStyle() {
		WebElement message = driver.findElement(By.id("message"));
		String width = message.getCssValue("width");
		assertEquals("150px", width);
	}

	@AfterClass
	public static void tearDown() {
		driver.close();
	}
}

