package pack.drivers;

import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.support.ui.ExpectedConditions;
import org.openqa.selenium.support.ui.WebDriverWait;
import org.testng.Assert;
import pack.ObjRep.ObjectRepository;

import java.util.concurrent.TimeUnit;


public class loadDriver {

	private static WebDriver driver;

	public static void Firefox() {
		driver = new FirefoxDriver();
		driver.manage().window().maximize();
		System.out.println("Przeglądarka Firefox została zainicjowana...");
	}
	public static void IE()	{
		driver = new InternetExplorerDriver();
		driver.manage().window().maximize();
        System.out.println("Przeglądarka Internet Explorer została zainicjowana...");
	}
	public static void Chrome() {
		driver = new ChromeDriver();
		driver.manage().window().maximize();
        System.out.println("Przeglądarka Google Chrome została zainicjowana...");
	}
    public static void URL() {
        driver.get(ObjectRepository.URL);
    }
    public static void waitForID(String id) {
        WebDriverWait wait = new WebDriverWait(driver, 10);
        wait.until(ExpectedConditions.presenceOfElementLocated(By.id(id)));
    }
    public static void WaitForPageLoad() {
        driver.manage().timeouts().pageLoadTimeout(10, TimeUnit.SECONDS);
    }
    public static void clearID(String id) {
        driver.findElement(By.id(id)).clear();
    }
    public static void submit(String id) {
        driver.findElement(By.id(id)).submit();
    }
    public static void assertPageTitle() {
        Assert.assertEquals(driver.getTitle(), ObjectRepository.title);
    }
    public static void insertText(String id, String searchValue) {
        driver.findElement(By.id(id)).sendKeys(searchValue);
    }
    public static void exit() {
        driver.close();
        driver.quit();
    }
    public static void sleeper(int value) throws InterruptedException {
        Thread.sleep(value);
    }
}
