package pack;

import net.jsourcerer.webdriver.jserrorcollector.JavaScriptError;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.firefox.FirefoxProfile;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import java.util.List;

public class JSError {

    private WebDriver driver;
    private String baseUrl;
    private boolean acceptNextAlert = true;
    private StringBuffer verificationErrors = new StringBuffer();

    @BeforeTest
    public void setUp() throws Exception {
        FirefoxProfile ffProfile = new FirefoxProfile();
        JavaScriptError.addExtension(ffProfile);
        driver = new FirefoxDriver(ffProfile);
        baseUrl = "http://404checker.com";
    }

    @Test
    public void Test01() throws Exception {
        driver.get(baseUrl + "/");
        Thread.sleep(5000);
    }

    @AfterTest
    public void tearDown() throws Exception {
        List<JavaScriptError> jsError = JavaScriptError.readErrors(driver);
        System.out.println("——————Lista błędów JavaScript——————");
        for (int i = 0; i < jsError.size(); i++) {
            System.out.println(jsError.get(i).getErrorMessage());
            System.out.println("Linia błędu: " + jsError.get(i).getLineNumber());
            System.out.println(jsError.get(i).getSourceName());
        }
        System.out.println("——————Koniec listy———————");
        System.out.println("\n");
        driver.close();
        driver.quit();
    }

}