package pack;

import com.opera.core.systems.OperaDriver;
import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.chrome.ChromeDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.ie.InternetExplorerDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.safari.SafariDriver;
import org.testng.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Parameters;
import org.testng.annotations.Test;

import java.net.MalformedURLException;

/**
 * Plik stworzony przez prashanth_sams, dnia 11/12/14.
 */

public class CrossBrowser {

    private WebDriver driver;
    private String baseUrl;
    private boolean acceptNextAlert = true;
    private StringBuffer verificationErrors = new StringBuffer();

    @BeforeTest
    @Parameters({"browser"})
    public void setUp(String browser) throws MalformedURLException {
        if (browser.equalsIgnoreCase("Firefox")) {
            System.out.println("Uruchamiam Firefoxa");
            driver = new FirefoxDriver();
        } else if (browser.equalsIgnoreCase("chrome")) {
            System.out.println("Uruchamiam Chrome");
//            System.setProperty("webdriver.chrome.driver","C:\\chromedriver.exe");
            driver = new ChromeDriver();
        } else if (browser.equalsIgnoreCase("InternetExplorer")) {
            System.out.println("Uruchamiam Internet Explorera");
            System.setProperty("webdriver.ie.driver", "C:\\IEDriverServer.exe");
            DesiredCapabilities dc = DesiredCapabilities.internetExplorer();
            dc.setCapability(InternetExplorerDriver.INTRODUCE_FLAKINESS_BY_IGNORING_SECURITY_DOMAINS, true);  //Jeżeli IE nie zadziała, usuń tą linie i wyłącz tryb chroniony dla wszystkich 4 stref w opcjach Internetowych
            driver = new InternetExplorerDriver(dc);
        } else if (browser.equalsIgnoreCase("safari")) {
            System.out.println("Uruchamiam Safari");
            driver = new SafariDriver();
        } else if (browser.equalsIgnoreCase("opera")) {
            System.out.println("Uruchamiam Operę");
            // driver = new OperaDriver();       --Wykorzystaj tę linię, jeżeli lokalizacja jest ustawiona poprawnie
            DesiredCapabilities capabilities = new DesiredCapabilities();
            capabilities.setCapability("opera.binary", "C://Program Files (x86)//Opera//opera.exe");
            capabilities.setCapability("opera.log.level", "CONFIG");
            driver = new OperaDriver(capabilities);
        }
    }

    @Test
    public void GoogleTest() throws Exception {
        driver.get("http://www.google.com/");
        System.out.println("Tytuł strony to: " + driver.getTitle());
        Assert.assertEquals("Google", driver.getTitle());
        WebElement element = driver.findElement(By.name("q"));
        element.sendKeys("Selenium Podstawy");
        element.submit();
    }

    @AfterTest
    public void tearDown() throws Exception {
        driver.quit();
    }

}