package pack;

import org.openqa.selenium.By;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.testng.Assert;
import org.testng.annotations.*;

import java.lang.reflect.Method;
import java.net.URL;

/**
 * Stworzone przez prashanth_sams, dnia 12/08/14.
 */
public class saucelabs {

    private WebDriver driver;

    @Parameters({"username", "key", "browser", "browserVersion"})
    @BeforeMethod
    public void setUp(@Optional("xxxxxxxxxxxx") String username,
                      @Optional("xxxxxxxx-xxxx-xxxx-xxxx-xxxxxxxxxxxx") String key,
                      @Optional("iphone") String browser,
                      @Optional("5.0") String browserVersion,
                      Method method) throws Exception {

        // Wybierz przeglądarkę, wersję i platformę, na której mają być wykonane testy
        DesiredCapabilities capabilities = new DesiredCapabilities();
        capabilities.setBrowserName(browser);
        capabilities.setCapability("version", browserVersion);
        capabilities.setCapability("platform", Platform.MAC);
        capabilities.setCapability("name", method.getName());
        // Stwórz połączenie z SauceLabs w celu wykonania testów
        this.driver = new RemoteWebDriver(
                new URL("http://" + username + ":" + key + "@ondemand.saucelabs.com:80/wd/hub"),
                capabilities); 
    }

    @Test
    public void Selenium_Essentials() throws Exception {
        driver.get("http://www.google.com");
        System.out.println("Tytuł strony to: " + driver.getTitle());
        Assert.assertEquals("Google", driver.getTitle());
        WebElement element = driver.findElement(By.name("q"));
        element.sendKeys("Selenium Podstawy");
        element.submit();
    }

    @AfterMethod
    public void tearDown() throws Exception {
        driver.quit();
    }

}
