package pack;

import org.openqa.selenium.By;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;
import org.testng.Assert;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import java.util.concurrent.TimeUnit;

public class HTMLUnit {
    private WebDriver driver;
    private String baseUrl;

    @BeforeTest
    public void setUp() throws Exception {
        driver = new HtmlUnitDriver();
        baseUrl = "https://www.google.co.in";
        driver.manage().timeouts().implicitlyWait(30, TimeUnit.SECONDS);
    }

    @Test
    public void headlesstest() throws Exception {
        driver.get(baseUrl + "/");
        System.out.println("Tytuł strony to: " + driver.getTitle());
        Assert.assertEquals("Google", driver.getTitle());
        WebElement element = driver.findElement(By.name("q"));
        element.sendKeys("Selenium Podstawy");
        element.submit();

    }

    @AfterTest
    public void tearDown() throws Exception {
        driver.quit();
    }
}
