package Selenium_essentials;

import org.openqa.selenium.By;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.firefox.FirefoxDriver;
import org.openqa.selenium.support.events.AbstractWebDriverEventListener;
import org.openqa.selenium.support.events.EventFiringWebDriver;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

//import org.junit.Test;

/**
 * Plik stowrzony przez prashanth_sams, dnia 17/09/14.
 */

public class EventListener extends AbstractWebDriverEventListener {
    private WebDriver driver;
    private String baseUrl;

    @BeforeTest
    public void setUp() throws Exception {
        driver = new FirefoxDriver();
    }

    @Test
    public void Test01() throws Exception {

        EventFiringWebDriver eventDriver = new EventFiringWebDriver(driver);
        Listeners EL = new Listeners();
        eventDriver.register(EL);

        // beforeNavigateTo | afterNavigateTo
        eventDriver.get("http://www.bing.com");

        // beforeNavigateBack | afterNavigateBack
        eventDriver.get("http://www.google.com");
        eventDriver.navigate().back();

        // beforeNavigateForward | afterNavigateForward
        eventDriver.navigate().forward();

        // beforeFindBy | afterFindBy
        eventDriver.findElement(By.name("q"));

        // beforeClickOn | afterClickOn
        eventDriver.findElement(By.id("gbqfba")).click();

        // afterScript() | beforeScript()
        JavascriptExecutor jse = (JavascriptExecutor) eventDriver;
        jse.executeScript("alert('Książka Selenium Podstawy mnie ocaliła!')");

        // beforeChangeValueOf | afterChangeValueOf
        eventDriver.findElement(By.name("q")).sendKeys("Selenium Podstawy");

        // onException
        eventDriver.findElement(By.id("Błędna wartość"));
    }

    @AfterTest
    public void tearDown() throws Exception {
        driver.quit();
    }
}
