package pack;

import org.apache.commons.io.FileUtils;
import org.openqa.selenium.By;
import org.openqa.selenium.OutputType;
import org.openqa.selenium.TakesScreenshot;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.phantomjs.PhantomJSDriver;
import org.testng.annotations.AfterTest;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import java.io.File;
import java.util.concurrent.TimeUnit;

public class phantomjs {
    private WebDriver driver;
    private String baseUrl;

    @BeforeTest
    public void setUp() throws Exception {
        System.setProperty("phantomjs.binary.path", "/Users/prashanth_sams/phantomjs");
        driver = new PhantomJSDriver();
        baseUrl = "https://www.google.co.in";
        driver.manage().timeouts().implicitlyWait(30, TimeUnit.SECONDS);
    }

    @Test
    public void headlesstest() throws Exception {
        driver.get(baseUrl + "/");
        driver.findElement(By.name("q")).sendKeys("Selenium Podstawy");

        File scrFile = ((TakesScreenshot)driver).getScreenshotAs(OutputType.FILE);
        FileUtils.copyFile(scrFile, new File("/Users/prashanth_sams/screen_shot.jpeg"),true);
    }

    @AfterTest
    public void tearDown() throws Exception {
        driver.quit();
    }
}
