package pack;

import org.openqa.selenium.By;
import org.openqa.selenium.Platform;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.WebElement;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.openqa.selenium.remote.RemoteWebDriver;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

import java.net.URL;

public class testingbot {
    private WebDriver driver;

    @BeforeClass
    public void setUp() throws Exception {
        DesiredCapabilities capabillities = DesiredCapabilities.firefox();
        capabillities.setCapability("version", "24");
        capabillities.setCapability("platform", Platform.WINDOWS);
        capabillities.setCapability("name", "testOnCloud");
        capabillities.setCapability("screenshot", true);
        capabillities.setCapability("screenrecorder", true);
        driver = new RemoteWebDriver(
                new URL(
                        "http://yourclientKey:yourclientSecret@hub.testingbot.com:4444/wd/hub"),
                capabillities);
    }

    @Test
    public void testOnCloud() throws Exception {
        driver.get("http://www.google.co.in/");
        driver.findElement(By.id("gbqfq")).clear();
        WebElement element = driver.findElement(By.id("gbqfq"));
        element.sendKeys("selenium");
        Assert.assertEquals("selenium - Google Search", driver.getTitle());
    }

    @AfterClass
    public void tearDown() throws Exception {
        driver.quit();
    }
}
