package test

import scala.collection.Traversable

/** Ta klasa opakowuje java.io.File w API Scali o większych możliwościach */
class FileWrapper(val file : java.io.File) {
   /** Ta metoda składa ścieżki do pliku. Mimo że nazywa się /,
   * w Windows zadziała zgodnie z oczekiwaniami. 
   */
  def /(next : String) = new FileWrapper(new java.io.File(file, next))

  /**
   * Ta metoda zwróci kolekcję Traversable przechodzącą przez linie w pliku.
   */
  def lines : Traversable[String] = new Traversable[String] {
    override def foreach[U](f : String => U) : Unit = {
      import java.io._
      val reader = new BufferedReader(new FileReader(file))
      try {
        var line = reader.readLine()
        while(line != null) {
          f(line)
          line = reader.readLine()
        }
      } finally {
        reader.close();
      }
    }
  }
  override def toString = file.getCanonicalPath
}

/**
 * Obiekt towarzyszący FileWrapper, który potrafi zamienić java.io.File w FileWrapper i odwrotnie. 
 */
object FileWrapper {
  implicit def unwrap(w : FileWrapper) = w.file
  implicit def wrap(f : java.io.File) = new FileWrapper(f)
}

/** Ten obiekt testuje widoki domniemane FileWrapper. */
object Test {
  // To jedyny domniemany import niezbędny do realizacji obustronnej konwersji 
  // pomiędzy opakowanym i zwykłym java.io.File.
  import FileWrapper.wrap
  /** Ta metoda pobiera java.io.File i wypisuje linie z pliku. Demonstruje ona działanie domniemanych widoków. */
  def withFile(f : java.io.File) : Unit = {
    for(line <- f.lines) println(line)
  }

  def test() {
    val currentDirectory = new java.io.File(".")
    // opakowywanie i odpakowywanie w oparciu o domniemany widok odbywa się właśnie tutaj
    withFile( currentDirectory / "tmp.txt" )
  }
}