package scattergather

import collection.immutable.HashMap
import akka.actor.{ReceiveTimeout, ActorRef, Actor}

/** Definiuje węzeł wyszukiwawczy SearchNode zawierający fragment indeksu */
class SearchNode(id : Int) extends Actor {
  // TODO - inicjalizacja indeksu
  lazy val index : HashMap[String, Seq[(Double, String)]] = {
    def makeIndex(docs : String*) = {
      var tmp = HashMap[String, Seq[(Double, String)]]()
      for( doc <- docs; (key,value) <- doc.split("\\s+").groupBy(identity)) {
        val list = tmp.get(key) getOrElse Seq()
        tmp += ((key, ((value.length.toDouble, doc)) +: list))
      }
      tmp
    }
    id match {
      case 1 => makeIndex("Trochę przykładowych danych")
      case 2 => makeIndex("Jeszcze więcej przykładowych danych")
      case 3 => makeIndex("Być albo nie być, oto jest pytanie")
      case 4 => makeIndex("OMG to kot!")
      case 5 => makeIndex("To przykład. Naprawdę świetny.")
      case 6 => makeIndex("HAI there", "HAI IZ HUNGRY")
      case 7 => makeIndex("Witaj, świecie")
      case 8 => makeIndex("Witaj, witamy w węźle wyszukiwawczym nr 8")
      case 9 => makeIndex("Leniwy brązowy lis przeskoczył nad")
      case 10 => makeIndex("Wygrywanie jest najlepsze, bo to wygrywanie!")
    }
  }
  def receive = {
    case SearchQuery(query, maxDocs, handler) =>
      val result = for {
        results <- index.get(query).toList
        resultList <- results
      } yield resultList
      handler ! QueryResponse(result.take(maxDocs))
  }
}

/** Główny wierzchołek drzewa.
    Uwaga: drzewo może mieć kilka poziomów głębokości,
	węzły główne mogą wskazywać na inne węzły główne.
 */
class HeadNode extends Actor {
  // TODO - inicjalizacja węzłów wyszukiwawczych
  def nodes : Seq[ActorRef] = Seq()
  def receive = {
     case SearchQuery(q, max, responder) =>
        val gatherer = Actor.actorOf(new GathererNode {
          val maxDocs = max
          val maxResponses = nodes.size
          val query = q
          val client = responder
        })
        gatherer.start
        for (node <- nodes) {
          node ! SearchQuery(q, max, gatherer)
        }
  }
}
/** Aktor, który odbiera rozproszone wyniki, łączy je i odpowiada na oryginalne zapytanie. */
trait GathererNode extends Actor {
  val maxDocs : Int
  val query : String
  val maxResponses : Int
  val client : ActorRef
  self.receiveTimeout = Some(1000L)
  /** Przechowuje aktualny zbiór wyników */
  var results = Seq[(Double, String)]()
  var responseCount = 0
  /** Łączy dwa zbiory wyników. */
  private def combineResults(current : Seq[(Double, String)], next : Seq[(Double, String)]) =
    (current ++ next).view.sortBy(_._1).take(maxDocs).force

  def receive = {
    case QueryResponse(next) =>
      results = combineResults(results, next)
      responseCount += 1
      if(responseCount == maxResponses) {
        client ! QueryResponse(results)
        self.stop()
      }
      ()
    case ReceiveTimeout =>
      client ! QueryResponse(Seq())
      self.stop()
  }
}