package chapter9

import scala.util.control.NonFatal

/**
  * Utworzony przez vika dnia 18/06/17.
  */
object PatternMatching extends App {

  def matchAgainst(i: Int) = i match {
    case 1 => println("Jeden")
    case 2 => println("Dwa")
    case 3 => println("Trzy")
    case 4 => println("Cztery")
    case _ => println("Poza przedziałem od 1 do 4")
  }

  matchAgainst(1)
  matchAgainst(5)

  val somelist = 1 :: 2 :: 3 :: Nil

  val x = somelist match {
    case Nil => Nil
    case _ => println(s"coś")
    case head :: tail => println("cokolwiek związanego z wartościami head i tail")
  }

  def safeToInt(canBeNumber: String): Option[Int] = {
    try {
      Some(canBeNumber.toInt)
    } catch {
      case NonFatal(e) => None
    }
  }

  safeToInt("10") match {
    case None => println(s"Nic nie znaleziono")
    case Some(value) =>  println(s"Otrzymano wartość $value")
  }

  //lazy val x = processRecords

  def processRecords =


  safeToInt("ten") map println
  safeToInt("10") map println
  safeToInt("s10") map println


  trait Employee
  case class ContractEmp(id: String, name: String) extends Employee
  case class Developer(id: String, name: String) extends Employee
  case class Consultant(id: String, name: String) extends Employee

  def generateIdOp(emp: Employee): Option[String]= emp match {
    case c: ContractEmp => Some("C" + c.id)
    case d: Developer => Some("D" + d.id)
    case cn: Consultant => Some("CN" + cn.id)
    case _ => None
  }

 /*
  * Przetworzenie dodatku, jeśli:
  *     :> identyfikator programisty rozpoczyna się od "DL"  JB: 1L
  *     :> identyfikator konsultanta rozpoczyna się od "CNL":  1L
  */
  def processJoiningBonus(employee: Employee, amountCTC: Double) = employee match {
    case ContractEmp(id, _) => amountCTC
    case Developer(id, _) if id.startsWith("DL") => amountCTC + 10000.0
    case Consultant(id, _) if id.startsWith("CNL") =>  amountCTC + 10000.0
    case _ => amountCTC
  }

  val developerEmplEligibleForJB = Developer("DL0001", "Aleksander")
  val consultantEmpEligibleForJB = Consultant("CNL0001","Henryk")
  val developer = Developer("DI0002", "Heith")

  println(processJoiningBonus(developerEmplEligibleForJB, 55000))
  println(processJoiningBonus(consultantEmpEligibleForJB, 65000))
  println(processJoiningBonus(developer, 66000))

  case class Car(name: String, brand: CarBrand)
  case class CarBrand(name: String)

  val car = Car("Model X", CarBrand("Tesla"))
  val anyCar = Car("Model XYZ", CarBrand("XYZ"))

  def matchCar(c: Car) = c match {
    case Car(_, brand @ CarBrand("Tesla")) => println(s"To jest samochód Tesla!")
    case _ => println(s"To jest zwykły samochód!!")
  }

  matchCar(car)
  matchCar(anyCar)
}

