package chapter7

trait Socialize {

  def greet(name: String) = "Witaj, " + name

  val socialNetworks = Set("Facebook", "LinkedIn", "Twitter", "Instagram", "Youtube")

  def linkToSocialNetwork(network: String, uri: String)
}

case class Person(val name: String)

object SocializeApp extends App {
  val person = Person("Jan Kowalski")

  val employee = new Employee("Dawid Baranowski")
  employee.linkToSocialNetwork("LinkedIn", "www.linkedin.com/profiles/david_b")

  println(employee.mapOfSocialNetwork)

}

class Employee(fullName: String) extends Person(fullName) with Socialize {
  var mapOfSocialNetwork = new scala.collection.mutable.HashMap[String, String]()

  override val socialNetworks = Set("LinkedIn", "Twitter", "Youtube")
  override def linkToSocialNetwork(network: String, uri: String): Unit = if (socialNetworks contains network) mapOfSocialNetwork.put(network, uri)

}
  //println(person.greet(employee.name))

