package chapter6

class Country(val name: String, val capital: String){
  var populationMap = scala.collection.mutable.Map[String, Double]()
  def getPopulation(year: String): Double = populationMap(year) // W milionach.

  override def toString: String = s"Country($name,$capital)"
}

object Country {
  /*
  * Funkcja pobiera sekwencję wyrażonych w milionach elementów populacji i zwraca średnią.
  */
  def populationAverage(pops: Seq[Double]) = pops.sum / pops.length
}

object CountryApp extends App {
  val country = new Country("Francja", "Paryż")
  country.populationMap += ("2015" -> 64.39) += ("2016" -> 64.67) += ("2017" -> 64.93)

  println(s"Nazwa kraju: ${country.name}, populacja w roku 2017: ${country.getPopulation("2017")} miliona")

  println(s"Średnia populacja w kraju ${country.name}'s wynosi: ${Country.populationAverage(country.populationMap.values.toSeq)}")
}



