package chapter6

import java.time.LocalDate
import java.time.format.{DateTimeFormatter, TextStyle}
import java.util.Locale
import scala.util.{Failure, Success, Try}

object DateUtil {
  /*
  * Wystarczy przekazać datę w formacie DD/MM/RRRR, wartością zwrotną jest dzień tygodnia.
  * */
  def dayOfWeek(date: String): Option[String] = Try{
      LocalDate.parse(date, DateTimeFormatter.ofPattern("dd/MM/yyyy")).getDayOfWeek
    } match {
      case Success(dayOfWeek) => Some(dayOfWeek.getDisplayName(TextStyle.FULL, Locale.ENGLISH))
      case Failure(exp) => exp.printStackTrace; None
    }
}

object TestDateUtil extends App {
  import DateUtil._

  val date = "01/01/1992"

  dayOfWeek(date) match {
      case Some(dow) => println(s"W dniu $date był(a) $dow")
      case None => println(s"Wystąpił błąd!")
  }

}