package chapter4


object ColorPrinter extends App {

  val printerSwitch = false

  def printPages(doc: Document, lastIndex: Int, print: (Int) => Unit) = {

    if(lastIndex <= doc.numOfPages && !printerSwitch) for(i <- 1 to lastIndex) print(i)

  }

  val colorPrint = (index: Int) => println(s"Wydruk kolorowej strony nr $index.")

  val colorPrintV2 = new Function1[Int, Unit]{
    override def apply(index: Int): Unit =
      println(s"Wydruk kolorowej strony nr $index.")
  }

  println("---------Funkcja V1-----------")
  printPages(Document(15, "DOCX"), 2, colorPrint)

  println("---------Funkcja V2-----------")
  printPages(Document(15, "DOCX"), 2, colorPrintV2)

}

case class Document(numOfPages: Int, typeOfDoc: String)



/*
* println("---------Metoda V3-----------")
  printPages(chapter3.Document(15, "DOCX"), 2, colorPrintV3, !printerSwitch)
*
* */

/*object AClosure extends App {

  var advertisement = "Kup iPhone7"

  val playingShow = (showName: String) => println(s"Emisja programu $showName.
Oto treść reklamy: $advertisement")

  playingShow("GOT")

  advertisement = "Kup iPhone8"

  playingShow("GOF")

}*/
