package chapter3

object PagePrinter extends App{

  /*
  *
  * Wydruk stron dokumentu, od 1. do lastIndex.
  *
  */
  def printPages(doc: Document, lastIndex: Int) = if(lastIndex <= doc.numOfPages) for(i <- 1 to lastIndex) print(i)

  /*
  *
  * Wydruk stron dokumentu, od startIndex do lastIndex.
  *
  */
  def printPages(doc: Document, startIndex: Int, lastIndex: Int) = if(lastIndex <= doc.numOfPages && startIndex > 0 && startIndex < lastIndex) for(i <- startIndex to lastIndex) print(i)

  /*
  *
  * Wydruk stron dokumentu o podanych numerach.
  *
  */
  def printPages(doc: Document, indexes: Int*) = for(index <- indexes if index <= doc.numOfPages && index > -1) print(index)

  /*
  *  Wydruk stron dokumentu.
  */
  private def print(index: Int) = println(s"Wydruk strony nr $index.")

  println("---------Metoda V1-----------")
  printPages(Document(15, "DOCX"), 10)

  println("---------Metoda V2-----------")
  printPages(Document(15, "DOCX"), 2, 10)

  println("---------Metoda V3-----------")
  printPages(Document(15, "DOCX"), 2, 5, 7, 10, 12, 15)


}

case class Document(numOfPages: Int, typeOfDoc: String)
